-- jeli funkcja o takiej nazwie ju istnieje to j usu
IF OBJECT_ID (N'dbo.getProductMembersByInfo') IS NOT NULL
   DROP FUNCTION dbo.getProductMembersByInfo
GO

-- utwrz funkcj przyjmujc dwa parametry i zwracajc jako wynik tabel
CREATE FUNCTION dbo.getProductMembersByInfo (@MEM_INFO VARCHAR(50), @INCLUDE_PARENT BIT )
RETURNS @ProductMembers TABLE 
(
	MEM_ID		INT NOT NULL,
	MEM_NAME	VARCHAR(50) NOT NULL,
	MEM_DESC	VARCHAR(255) NOT NULL,
	MEM_PID		INT NOT NULL
)
AS

BEGIN
	--Jeli @parametr @INCLUDE_PARENT ma warto 1 
	--to wstaw do tabeli rekord rodzica odnajdujc do po nazwie lub identyfikatorze
	IF @INCLUDE_PARENT = 1
	BEGIN
		INSERT @ProductMembers
			SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
			FROM PRODUCT_PC
			WHERE MEM_NAME = @MEM_INFO 	-- jeli w @MEM_INFO jest nazwa
				-- lub gdy w @MEM_INFO jest identyfikator
				OR MEM_ID = ( CASE
						WHEN ISNUMERIC(@MEM_INFO)=0 
-- warto 0 nie uywana przez aden element wymiaru
						THEN 0 
						ELSE @MEM_INFO
				      	      END)
	END

	--Wstaw wszystkie dzieci rodzica, ktrego nazwa lub identyfikator 
	--zosta okrelona w parametrze @MEM_INFO
	INSERT @ProductMembers
		SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
		FROM PRODUCT_PC
		WHERE MEM_PID = 
(SELECT MEM_ID FROM PRODUCT_PC 
			WHERE MEM_NAME = @MEM_INFO 
				OR MEM_ID =  (CASE
						WHEN ISNUMERIC(@MEM_INFO)=0 
						THEN 0 
						ELSE @MEM_INFO
					      END))
   RETURN
END
GO
